import datetime
import logging
import os
import time
import uuid

#
_log_level={
    'FATAL' : logging.FATAL,
    'ERROR' : logging.ERROR,
    'WARN' : logging.WARN,
    'INFO' : logging.INFO,
    'DEBUG' : logging.DEBUG,
    'NOTSET' : logging.NOTSET,
}


class ZLog:
    def __init__(self, log_dir = './log/', log_level_str = 'INFO'):
        if not os.path.exists(log_dir):
            os.makedirs(log_dir)
        log_level = logging.INFO
        if log_level_str in _log_level:
            log_level = _log_level[log_level_str]
        formatted_time = time.strftime("%Y_%m_%d", time.localtime(time.time()))
        logFile = os.path.join(log_dir, formatted_time+'.log')
        name = str(uuid.uuid4())
        self.logger = logging.getLogger(name)
        self.logger.setLevel(log_level)
        file_handler = logging.FileHandler(logFile, encoding='utf-8')
        formatter = logging.Formatter('%(asctime)s - %(levelname)s - %(message)s')
        file_handler.setFormatter(formatter)
        self.logger.addHandler(file_handler)
    
    def cDebug(self, msg):
        print(datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S") + " DEBUG " + str(msg))
        self.logger.debug(msg)

    def cInfo(self, msg):
        print(datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S") + " INFO  " + str(msg))
        self.logger.info(msg)

    def cError(self, msg):
        print(datetime.datetime.now().strftime("%Y-%m-%d %H:%M:%S") + " ERROR " + str(msg))
        self.logger.error(msg)
    
    def debug(self, msg):
        self.logger.debug(msg)

    def info(self, msg):
        self.logger.info(msg)

    def error(self, msg):
        self.logger.error(msg)
    